/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.tileentity;

import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.api.crafting.ITableRecipe;
import com.blakebr0.extendedcrafting.api.crafting.RecipeTypes;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.container.AdvancedAutoTableContainer;
import com.blakebr0.extendedcrafting.container.BasicAutoTableContainer;
import com.blakebr0.extendedcrafting.container.EliteAutoTableContainer;
import com.blakebr0.extendedcrafting.container.UltimateAutoTableContainer;
import com.blakebr0.extendedcrafting.container.inventory.ExtendedCraftingInventory;
import com.blakebr0.extendedcrafting.crafting.TableRecipeStorage;
import com.blakebr0.extendedcrafting.init.ModTileEntities;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class AutoTableTileEntity
extends BaseInventoryTileEntity
implements MenuProvider {
    private static final AbstractContainerMenu EMPTY_CONTAINER = new AbstractContainerMenu(null, -1){

        public boolean m_6875_(Player player) {
            return false;
        }
    };
    private WrappedRecipe recipe;
    private int progress;
    private boolean running = true;
    private int oldEnergy;
    private boolean isGridChanged = true;

    public AutoTableTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Progress", this.progress);
        tag.m_128379_("Running", this.running);
        tag.m_128365_("Energy", this.getEnergy().serializeNBT());
        tag.m_128391_(this.getRecipeStorage().serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128451_("Progress");
        this.running = tag.m_128471_("Running");
        this.getEnergy().deserializeNBT(tag.m_128423_("Energy"));
        this.getRecipeStorage().deserializeNBT(tag);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.m_58901_() && cap == CapabilityEnergy.ENERGY) {
            return CapabilityEnergy.ENERGY.orEmpty(cap, LazyOptional.of(this::getEnergy));
        }
        return super.getCapability(cap, side);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AutoTableTileEntity tile) {
        int selected;
        boolean mark = false;
        EnergyStorage energy = tile.getEnergy();
        if (tile.running) {
            tile.updateRecipeInventory();
            Container recipeInventory = tile.getRecipeInventory().toIInventory();
            if (tile.isGridChanged && (tile.recipe == null || !tile.recipe.matches(recipeInventory, level))) {
                ITableRecipe recipe = level.m_7465_().m_44015_(RecipeTypes.TABLE, recipeInventory, level).orElse(null);
                WrappedRecipe wrappedRecipe = tile.recipe = recipe != null ? new WrappedRecipe(recipe) : null;
                if (tile.recipe == null && ((Boolean)ModConfigs.TABLE_USE_VANILLA_RECIPES.get()).booleanValue() && tile instanceof Basic) {
                    ExtendedCraftingInventory craftingInventory = new ExtendedCraftingInventory(EMPTY_CONTAINER, tile.getRecipeInventory(), 3);
                    CraftingRecipe vanilla = level.m_7465_().m_44015_(RecipeType.f_44107_, (Container)craftingInventory, level).orElse(null);
                    tile.recipe = vanilla != null ? new WrappedRecipe(vanilla, craftingInventory) : null;
                }
                tile.isGridChanged = false;
            }
            if (!level.m_5776_()) {
                if (tile.recipe != null) {
                    BaseItemStackHandler inventory = tile.getInventory();
                    ItemStack result = tile.recipe.getCraftingResult(recipeInventory);
                    int outputSlot = inventory.getSlots() - 1;
                    ItemStack output = inventory.getStackInSlot(outputSlot);
                    int powerRate = (Integer)ModConfigs.AUTO_TABLE_POWER_RATE.get();
                    if (StackHelper.canCombineStacks((ItemStack)result, (ItemStack)output) && energy.getEnergyStored() >= powerRate) {
                        ++tile.progress;
                        energy.extractEnergy(powerRate, false);
                        if (tile.progress >= tile.getProgressRequired()) {
                            NonNullList<ItemStack> remaining = tile.recipe.getRemainingItems(recipeInventory);
                            for (int i = 0; i < recipeInventory.m_6643_(); ++i) {
                                if (!((ItemStack)remaining.get(i)).m_41619_()) {
                                    inventory.setStackInSlot(i, (ItemStack)remaining.get(i));
                                    continue;
                                }
                                inventory.extractItemSuper(i, 1, false);
                            }
                            tile.updateResult(result, outputSlot);
                            tile.progress = 0;
                            tile.isGridChanged = true;
                        }
                        mark = true;
                    }
                } else if (tile.progress > 0) {
                    tile.progress = 0;
                    mark = true;
                }
            }
        } else if (tile.progress > 0) {
            tile.progress = 0;
            mark = true;
        }
        int insertPowerRate = (Integer)ModConfigs.AUTO_TABLE_INSERT_POWER_RATE.get();
        if (!level.m_5776_() && tile.getEnergy().getEnergyStored() >= insertPowerRate && (selected = tile.getRecipeStorage().getSelected()) != -1) {
            tile.getAboveInventory().ifPresent(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    boolean inserted;
                    ItemStack stack = handler.getStackInSlot(i);
                    if (stack.m_41619_() || handler.extractItem(i, 1, true).m_41619_() || !(inserted = tile.tryInsertItemIntoGrid(stack))) continue;
                    handler.extractItem(i, 1, false);
                    break;
                }
            });
        }
        if (tile.oldEnergy != energy.getEnergyStored()) {
            tile.oldEnergy = energy.getEnergyStored();
            if (!mark) {
                mark = true;
            }
        }
        if (mark) {
            tile.markDirtyAndDispatch();
        }
    }

    public int getProgress() {
        return this.progress;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void toggleRunning() {
        this.running = !this.running;
        this.markDirtyAndDispatch();
    }

    public void selectRecipe(int index) {
        this.getRecipeStorage().setSelected(index);
        this.markDirtyAndDispatch();
    }

    public void saveRecipe(int index) {
        Level level = this.m_58904_();
        if (level == null) {
            return;
        }
        this.updateRecipeInventory();
        BaseItemStackHandler recipeInventory = this.getRecipeInventory();
        Container recipeIInventory = recipeInventory.toIInventory();
        BaseItemStackHandler newRecipeInventory = new BaseItemStackHandler(recipeInventory.getSlots());
        for (int i = 0; i < recipeInventory.getSlots(); ++i) {
            newRecipeInventory.setStackInSlot(i, recipeInventory.getStackInSlot(i).m_41777_());
        }
        ItemStack result = ItemStack.f_41583_;
        ITableRecipe recipe = level.m_7465_().m_44015_(RecipeTypes.TABLE, recipeIInventory, level).orElse(null);
        if (recipe != null) {
            result = recipe.m_5874_(recipeIInventory);
        } else {
            ExtendedCraftingInventory craftingInventory = new ExtendedCraftingInventory(EMPTY_CONTAINER, recipeInventory, 3);
            CraftingRecipe vanilla = level.m_7465_().m_44015_(RecipeType.f_44107_, (Container)craftingInventory, level).orElse(null);
            if (vanilla != null) {
                result = vanilla.m_5874_((Container)craftingInventory);
            }
        }
        this.getRecipeStorage().setRecipe(index, newRecipeInventory, result);
        this.markDirtyAndDispatch();
    }

    public void deleteRecipe(int index) {
        this.getRecipeStorage().unsetRecipe(index);
        this.markDirtyAndDispatch();
    }

    public abstract int getProgressRequired();

    public abstract BaseItemStackHandler getRecipeInventory();

    public abstract TableRecipeStorage getRecipeStorage();

    public abstract EnergyStorage getEnergy();

    protected void onContentsChanged() {
        this.isGridChanged = true;
        this.markDirtyAndDispatch();
    }

    private void updateRecipeInventory() {
        BaseItemStackHandler inventory = this.getInventory();
        this.getRecipeInventory().setSize(inventory.getSlots() - 1);
        for (int i = 0; i < inventory.getSlots() - 1; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            this.getRecipeInventory().setStackInSlot(i, stack);
        }
    }

    private void updateResult(ItemStack stack, int slot) {
        BaseItemStackHandler inventory = this.getInventory();
        ItemStack result = inventory.getStackInSlot(inventory.getSlots() - 1);
        if (result.m_41619_()) {
            inventory.setStackInSlot(slot, stack);
        } else {
            inventory.setStackInSlot(slot, StackHelper.grow((ItemStack)result, (int)stack.m_41613_()));
        }
    }

    private void addStackToSlot(ItemStack stack, int slot) {
        BaseItemStackHandler inventory = this.getInventory();
        ItemStack stackInSlot = inventory.getStackInSlot(slot);
        if (stackInSlot.m_41619_()) {
            inventory.setStackInSlot(slot, stack);
        } else {
            inventory.setStackInSlot(slot, StackHelper.grow((ItemStack)stackInSlot, (int)stack.m_41613_()));
        }
    }

    private LazyOptional<IItemHandler> getAboveInventory() {
        BlockEntity tile;
        Level level = this.m_58904_();
        BlockPos pos = this.m_58899_().m_7494_();
        if (level != null && (tile = level.m_7702_(pos)) != null) {
            return tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN);
        }
        return LazyOptional.empty();
    }

    private boolean tryInsertItemIntoGrid(ItemStack input) {
        BaseItemStackHandler inventory = this.getInventory();
        ItemStack stackToPut = ItemStack.f_41583_;
        BaseItemStackHandler recipe = this.getRecipeStorage().getSelectedRecipe();
        int slotToPut = -1;
        boolean isGridChanged = false;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack slot = inventory.getStackInSlot(i);
            ItemStack recipeStack = recipe.getStackInSlot(i);
            if (!slot.m_41619_() && !StackHelper.areStacksEqual((ItemStack)input, (ItemStack)slot) || !StackHelper.areStacksEqual((ItemStack)input, (ItemStack)recipeStack) || !slot.m_41619_() && slot.m_41613_() >= slot.m_41741_()) continue;
            if (slot.m_41619_()) {
                slotToPut = i;
                isGridChanged = true;
                break;
            }
            if (!stackToPut.m_41619_() && slot.m_41613_() >= stackToPut.m_41613_()) continue;
            slotToPut = i;
            stackToPut = slot;
        }
        this.isGridChanged = isGridChanged;
        if (slotToPut > -1) {
            int insertPowerRate = (Integer)ModConfigs.AUTO_TABLE_INSERT_POWER_RATE.get();
            ItemStack toInsert = StackHelper.withSize((ItemStack)input, (int)1, (boolean)false);
            this.addStackToSlot(toInsert, slotToPut);
            this.getEnergy().extractEnergy(insertPowerRate, false);
            return true;
        }
        return false;
    }

    public static class WrappedRecipe {
        private final Function<Container, ItemStack> resultFunc;
        private final BiFunction<Container, Level, Boolean> matchesFunc;
        private final Function<Container, NonNullList<ItemStack>> remainingItemsFunc;

        public WrappedRecipe(CraftingRecipe recipe, CraftingContainer craftingInventory) {
            this.resultFunc = inventory -> recipe.m_5874_((Container)craftingInventory);
            this.matchesFunc = (inventory, world) -> recipe.m_5818_((Container)craftingInventory, world);
            this.remainingItemsFunc = inventory -> recipe.m_7457_((Container)craftingInventory);
        }

        public WrappedRecipe(ITableRecipe recipe) {
            this.resultFunc = arg_0 -> ((ITableRecipe)recipe).m_5874_(arg_0);
            this.matchesFunc = (arg_0, arg_1) -> ((ITableRecipe)recipe).m_5818_(arg_0, arg_1);
            this.remainingItemsFunc = arg_0 -> ((ITableRecipe)recipe).m_7457_(arg_0);
        }

        public ItemStack getCraftingResult(Container inventory) {
            return this.resultFunc.apply(inventory);
        }

        public boolean matches(Container inventory, Level world) {
            return this.matchesFunc.apply(inventory, world);
        }

        public NonNullList<ItemStack> getRemainingItems(Container inventory) {
            return this.remainingItemsFunc.apply(inventory);
        }
    }

    public static class Basic
    extends AutoTableTileEntity {
        private final BaseItemStackHandler inventory = Basic.createInventoryHandler(this::onContentsChanged);
        private final BaseItemStackHandler recipeInventory = new BaseItemStackHandler(9);
        private final TableRecipeStorage recipeStorage = new TableRecipeStorage(10);
        private final EnergyStorage energy = new EnergyStorage(((Integer)ModConfigs.AUTO_TABLE_POWER_CAPACITY.get()).intValue());

        public Basic(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModTileEntities.BASIC_AUTO_TABLE.get(), pos, state);
        }

        public BaseItemStackHandler getInventory() {
            return this.inventory;
        }

        public Component m_5446_() {
            return Localizable.of((String)"container.extendedcrafting.basic_table").build();
        }

        public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
            return BasicAutoTableContainer.create(windowId, playerInventory, arg_0 -> ((Basic)this).isUsableByPlayer(arg_0), this.inventory, (ContainerData)new SimpleContainerData(0), this.m_58899_());
        }

        @Override
        public int getProgressRequired() {
            return 20;
        }

        @Override
        public BaseItemStackHandler getRecipeInventory() {
            return this.recipeInventory;
        }

        @Override
        public TableRecipeStorage getRecipeStorage() {
            return this.recipeStorage;
        }

        @Override
        public EnergyStorage getEnergy() {
            return this.energy;
        }

        public static BaseItemStackHandler createInventoryHandler(Runnable onContentsChanged) {
            BaseItemStackHandler inventory = new BaseItemStackHandler(10, onContentsChanged);
            inventory.setOutputSlots(new int[]{9});
            inventory.setSlotValidator((slot, stack) -> false);
            return inventory;
        }
    }

    public static class Ultimate
    extends AutoTableTileEntity {
        private final BaseItemStackHandler inventory = Ultimate.createInventoryHandler(this::onContentsChanged);
        private final BaseItemStackHandler recipeInventory = new BaseItemStackHandler(81);
        private final TableRecipeStorage recipeStorage = new TableRecipeStorage(82);
        private final EnergyStorage energy = new EnergyStorage((Integer)ModConfigs.AUTO_TABLE_POWER_CAPACITY.get() * 8);

        public Ultimate(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModTileEntities.ULTIMATE_AUTO_TABLE.get(), pos, state);
        }

        public BaseItemStackHandler getInventory() {
            return this.inventory;
        }

        public Component m_5446_() {
            return Localizable.of((String)"container.extendedcrafting.ultimate_table").build();
        }

        public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
            return UltimateAutoTableContainer.create(windowId, playerInventory, arg_0 -> ((Ultimate)this).isUsableByPlayer(arg_0), this.inventory, (ContainerData)new SimpleContainerData(0), this.m_58899_());
        }

        @Override
        public int getProgressRequired() {
            return 80;
        }

        @Override
        public BaseItemStackHandler getRecipeInventory() {
            return this.recipeInventory;
        }

        @Override
        public TableRecipeStorage getRecipeStorage() {
            return this.recipeStorage;
        }

        @Override
        public EnergyStorage getEnergy() {
            return this.energy;
        }

        public static BaseItemStackHandler createInventoryHandler(Runnable onContentsChanged) {
            BaseItemStackHandler inventory = new BaseItemStackHandler(82, onContentsChanged);
            inventory.setOutputSlots(new int[]{81});
            inventory.setSlotValidator((slot, stack) -> false);
            return inventory;
        }
    }

    public static class Elite
    extends AutoTableTileEntity {
        private final BaseItemStackHandler inventory = Elite.createInventoryHandler(this::onContentsChanged);
        private final BaseItemStackHandler recipeInventory = new BaseItemStackHandler(49);
        private final TableRecipeStorage recipeStorage = new TableRecipeStorage(50);
        private final EnergyStorage energy = new EnergyStorage((Integer)ModConfigs.AUTO_TABLE_POWER_CAPACITY.get() * 4);

        public Elite(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModTileEntities.ELITE_AUTO_TABLE.get(), pos, state);
        }

        public BaseItemStackHandler getInventory() {
            return this.inventory;
        }

        public Component m_5446_() {
            return Localizable.of((String)"container.extendedcrafting.elite_table").build();
        }

        public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
            return EliteAutoTableContainer.create(windowId, playerInventory, arg_0 -> ((Elite)this).isUsableByPlayer(arg_0), this.inventory, (ContainerData)new SimpleContainerData(0), this.m_58899_());
        }

        @Override
        public int getProgressRequired() {
            return 60;
        }

        @Override
        public BaseItemStackHandler getRecipeInventory() {
            return this.recipeInventory;
        }

        @Override
        public TableRecipeStorage getRecipeStorage() {
            return this.recipeStorage;
        }

        @Override
        public EnergyStorage getEnergy() {
            return this.energy;
        }

        public static BaseItemStackHandler createInventoryHandler(Runnable onContentsChanged) {
            BaseItemStackHandler inventory = new BaseItemStackHandler(50, onContentsChanged);
            inventory.setOutputSlots(new int[]{49});
            inventory.setSlotValidator((slot, stack) -> false);
            return inventory;
        }
    }

    public static class Advanced
    extends AutoTableTileEntity {
        private final BaseItemStackHandler inventory = Advanced.createInventoryHandler(this::onContentsChanged);
        private final BaseItemStackHandler recipeInventory = new BaseItemStackHandler(25);
        private final TableRecipeStorage recipeStorage = new TableRecipeStorage(26);
        private final EnergyStorage energy = new EnergyStorage((Integer)ModConfigs.AUTO_TABLE_POWER_CAPACITY.get() * 2);

        public Advanced(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModTileEntities.ADVANCED_AUTO_TABLE.get(), pos, state);
        }

        public BaseItemStackHandler getInventory() {
            return this.inventory;
        }

        public Component m_5446_() {
            return Localizable.of((String)"container.extendedcrafting.advanced_table").build();
        }

        public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
            return AdvancedAutoTableContainer.create(windowId, playerInventory, arg_0 -> ((Advanced)this).isUsableByPlayer(arg_0), this.inventory, (ContainerData)new SimpleContainerData(0), this.m_58899_());
        }

        @Override
        public int getProgressRequired() {
            return 40;
        }

        @Override
        public BaseItemStackHandler getRecipeInventory() {
            return this.recipeInventory;
        }

        @Override
        public TableRecipeStorage getRecipeStorage() {
            return this.recipeStorage;
        }

        @Override
        public EnergyStorage getEnergy() {
            return this.energy;
        }

        public static BaseItemStackHandler createInventoryHandler(Runnable onContentsChanged) {
            BaseItemStackHandler inventory = new BaseItemStackHandler(26, onContentsChanged);
            inventory.setOutputSlots(new int[]{25});
            inventory.setSlotValidator((slot, stack) -> false);
            return inventory;
        }
    }
}

